#include "tc_form.h"
#include "ui_tc_form.h"

#include "public_parameter.h"


// ------------ constructor & destructor ---------------
TC_Form::TC_Form(QWidget *parent, Qt::WindowFlags fl ):
    QWidget(parent, fl),
    ui(new Ui::TC_Form)
{
    ui->setupUi(this);
    this->is_fomr_started = false;
    this->TC_timer = 0;
    int index = 0;

    QLineEdit *temp_PwmPeriod_lineEdit[] = { this->ui->PwmPeriod_0_lineEdit, this->ui->PwmPeriod_1_lineEdit };
    QLineEdit *temp_PwmDuty_lineEdit[] = { this->ui->PwmDuty_0_lineEdit, this->ui->PwmDuty_1_lineEdit };
    QLabel *temp_PwmPeriodHz_label[] = { this->ui->PwmPeriodHz_0_label, this->ui->PwmPeriodHz_1_label };
    QLabel *temp_PwmDutyHz_label[] = { this->ui->PwmDutyHz_0_label, this->ui->PwmDutyHz_1_label };

    QPushButton *temp_TcControl_pushButton[] = { this->ui->TcControl_0_pushButton, this->ui->TcControl_1_pushButton };
    QComboBox *temp_TcMode_comboBox[] = { this->ui->TcMode_0_comboBox, this->ui->TcMode_1_comboBox };
    QComboBox *temp_TiMode_comboBox[] = { this->ui->TiMode_0_comboBox , this->ui->TiMode_1_comboBox };
    QComboBox *temp_ToMode_comboBox[] = { this->ui->ToMode_0_comboBox , this->ui->ToMode_1_comboBox };
    QComboBox *temp_Retrigger_comboBox[] = { this->ui->Retrigger_0_comboBox , this->ui->Retrigger_1_comboBox };

    QLineEdit *temp_PresetValue_lineEdit[] = { this->ui->PresetValue_0_lineEdit , this->ui->PresetValue_1_lineEdit };
    QLabel *temp_CurrentCounterValue_label[] = { this->ui->CurrentCounterValue_0_label , this->ui->CurrentCounterValue_1_label };
    QLineEdit *temp_PulseWidth_lineEdit[] = { this->ui->PulseWidth_0_lineEdit , this->ui->PulseWidth_1_lineEdit };

    QPushButton *temp_TimerSet_pushButton[] = { this->ui->TimerSet_0_pushButton , this->ui->TimerSet_1_pushButton };
    QPushButton *temp_CounterSet_pushButton[] = { this->ui->CounterSet_0_pushButton , this->ui->CounterSet_1_pushButton };
    QPushButton *temp_PwmSet_pushButton[] = { this->ui->PwmSet_0_pushButton , this->ui->PwmSet_1_pushButton };
    QPushButton *temp_SwDec_pushButton[] = { this->ui->SwDec_0_pushButton , this->ui->SwDec_1_pushButton };

    for( index = 0; index < 2 ; index++ )
      {
        this->PwmPeriod_lineEdit[ index ] = temp_PwmPeriod_lineEdit[ index ];
        this->PwmDuty_lineEdit[ index ] = temp_PwmDuty_lineEdit[ index ];
        this->PwmPeriodHz_label[ index ] = temp_PwmPeriodHz_label[ index ];
        this->PwmDutyHz_label[ index ] = temp_PwmDutyHz_label[ index ];

        this->TcControl_pushButton[ index ] = temp_TcControl_pushButton[ index ];

        this->TcMode_comboBox[ index ] = temp_TcMode_comboBox[ index ];
        this->TiMode_comboBox[ index ] = temp_TiMode_comboBox[ index ];
        this->ToMode_comboBox[ index ] = temp_ToMode_comboBox[ index ];
        this->Retrigger_comboBox[ index ] = temp_Retrigger_comboBox[ index ];

        this->PresetValue_lineEdit[ index ] = temp_PresetValue_lineEdit[ index ];
        this->CurrentCounterValue_label[ index ] = temp_CurrentCounterValue_label[ index ];
        this->PulseWidth_lineEdit[ index ] = temp_PulseWidth_lineEdit[ index ];

        this->TimerSet_pushButton[ index ] = temp_TimerSet_pushButton[ index ];
        this->CounterSet_pushButton[ index ] = temp_CounterSet_pushButton[ index ];
        this->PwmSet_pushButton[ index ] = temp_PwmSet_pushButton[ index ];
        this->SwDec_pushButton[ index ] = temp_SwDec_pushButton[ index ];
      }
 }

TC_Form::~TC_Form()
{
    delete ui;
}



// ------------ event ---------------
void TC_Form::showEvent(QShowEvent *)
{
    qWarning("showEvent");
    if ( false == this->is_fomr_started )
    {
        this->read_polarity();
        this->tc_parameter_read();
        this->read_pwm_data(0);
        this->read_pwm_data(1);

        this->TC_timer = startTimer(100);

        this->mode_lock(0, this->TcMode_comboBox[0]->currentIndex());
        this->mode_lock(1, this->TcMode_comboBox[1]->currentIndex());

        this->is_fomr_started = true;
    }
}

void TC_Form::timerEvent ( QTimerEvent *event )
{
    // qWarning("timer");
    if ( event->timerId() == this->TC_timer )
    {
        this->read_counter();
    }
}
void TC_Form::closeEvent ( QCloseEvent *event )
{
    // qWarning("closeEvent");

    killTimer(this->TC_timer);
    this->TC_timer = 0;

    this->is_fomr_started = false;
    event->accept();
}




// ------------ sub-function ---------------
void TC_Form::read_polarity()
{
    int index = 0;
    u8 polarity = 0;

    index = 0;
    EX94421A_TC_input_polarity_read( CardID, index, 0, &polarity );
    if ( ACTIVE == polarity )
    {
        this->ui->TiGatePolarity_0_checkBox->setChecked(true);
    }
    else
    {
        this->ui->TiGatePolarity_0_checkBox->setChecked(false);
    }

    EX94421A_TC_input_polarity_read( CardID, index, 1, &polarity );
    if ( ACTIVE == polarity )
    {
        this->ui->TiInputPolarity_0_checkBox->setChecked(true);
    }
    else
    {
        this->ui->TiInputPolarity_0_checkBox->setChecked(false);
    }

    EX94421A_TC_output_polarity_read( CardID, index, &polarity );
    if ( ACTIVE == polarity )
    {
        this->ui->ToPolarity_0_checkBox->setChecked(true);
    }
    else
    {
        this->ui->ToPolarity_0_checkBox->setChecked(false);
    }


    index = 1;
    EX94421A_TC_input_polarity_read( CardID, index, 0, &polarity );
    if ( ACTIVE == polarity )
    {
        this->ui->TiGatePolarity_1_checkBox->setChecked(true);
    }
    else
    {
        this->ui->TiGatePolarity_1_checkBox->setChecked(false);
    }

    EX94421A_TC_input_polarity_read( CardID, index, 1, &polarity );
    if ( ACTIVE == polarity )
    {
        this->ui->TiInputPolarity_1_checkBox->setChecked(true);
    }
    else
    {
        this->ui->TiInputPolarity_1_checkBox->setChecked(false);
    }

    EX94421A_TC_output_polarity_read( CardID, index, &polarity );
    if ( ACTIVE == polarity )
    {
        this->ui->ToPolarity_1_checkBox->setChecked(true);
    }
    else
    {
        this->ui->ToPolarity_1_checkBox->setChecked(false);
    }
}

void TC_Form::read_pwm_data(int index)
{
    i32 temp_period = 0;
    i32 temp_duty = 0;

    f64 T_period = 0.0;
    f64 T_duty = 0.0;

    if ( (0 != this->PwmPeriod_lineEdit[index]->text().toInt()) && (0 != this->PwmDuty_lineEdit[index]->text().toInt()) )
    {
        temp_period = ( 33000000 / this->PwmPeriod_lineEdit[index]->text().toInt() );
        temp_duty = ( 33000000 / this->PwmDuty_lineEdit[index]->text().toInt() );
        T_period = (1.0 / (f64)temp_period) * 1000.0 ;
        T_duty = (1.0 / (f64)temp_duty) * 1000.0;

        this->PwmPeriodHz_label[index]->setText("PWM Period: f="+ QString::number(temp_period) + "Hz, T=" + QString( "%1" ).arg ( T_period, 0, 'f', 5 ) + "ms"  );
        this->PwmDutyHz_label[index]->setText("PWM Duty: f="+ QString::number(temp_duty) + "Hz, T=" + QString( "%1" ).arg ( T_duty, 0, 'f', 5 ) + "ms"  );
    }
}

void TC_Form::tc_parameter_read()
{
    u32 data = 0;
    int index = 0;

    for( index = 0; index < 2 ; index++ )
    {
        // TC_CONTROL
        Status = EX94421A_TC_read( CardID, index, TC_CONTROL, &data );
        if ( 1 == data )
        {
            this->TcControl_pushButton[index]->setText("Control Off") ;
            this->TcControl_pushButton[index]->setChecked(true);
        }
        else if ( 0 == data )
        {
            this->TcControl_pushButton[index]->setText("Control On");
            this->TcControl_pushButton[index]->setChecked(false);
        }

        // TC_MODE
        Status = EX94421A_TC_read( CardID, index, TC_MODE, &data );
        if ( PWM_MODE == data )
        {
            this->TcMode_comboBox[index]->setCurrentIndex( 2 );
        }
        else
        {
            this->TcMode_comboBox[index]->setCurrentIndex( data );
        }

        // TI_GATE_MODE
        Status = EX94421A_TC_read( CardID, index, TI_GATE_MODE, &data );
        this->TiMode_comboBox[index]->setCurrentIndex( data );

        // TO_MODE
        Status = EX94421A_TC_read( CardID, index, TO_MODE, &data );
        if ( OUT_TOGGLE == data )
        {
            this->ToMode_comboBox[index]->setCurrentIndex( 3 );
        }
        else
        {
            this->ToMode_comboBox[index]->setCurrentIndex( data );
        }

        // RETRIGGER_MODE
        Status = EX94421A_TC_read( CardID, index, RETRIGGER_MODE, &data );
        this->Retrigger_comboBox[index]->setCurrentIndex( data );

        // PRELOAD
        Status = EX94421A_TC_read( CardID, index, PRELOAD, &data );
        this->PresetValue_lineEdit[index]->setText( QString::number(data,10) );

        // COUNTER
        Status = EX94421A_TC_read( CardID, index, COUNTER, &data );
        this->CurrentCounterValue_label[index]->setText( QString::number(data,10) );

        // OUT_WIDTH
        Status = EX94421A_TC_read( CardID, index, OUT_WIDTH, &data );
        this->PulseWidth_lineEdit[index]->setText( QString::number(data,10) );
    }
}

void TC_Form::read_counter()
{
    u32 data = 0;
    int index = 0;

    for ( index = 0; index < 2; index++ )
    {
        Status = EX94421A_TC_read( CardID, index, COUNTER, &data );
        this->CurrentCounterValue_label[index]->setText( QString::number(data, 10) );
    }
}

void TC_Form::object_lock(int index)
{
    this->TcMode_comboBox[index]->setEnabled(false);
    this->TiMode_comboBox[index]->setEnabled(false);
    this->ToMode_comboBox[index]->setEnabled(false);
    this->Retrigger_comboBox[index]->setEnabled(false);
    this->PresetValue_lineEdit[index]->setEnabled(false);
    this->PulseWidth_lineEdit[index]->setEnabled(false);
    this->PwmPeriod_lineEdit[index]->setEnabled(false);
    this->PwmDuty_lineEdit[index]->setEnabled(false);

    this->TimerSet_pushButton[index]->setEnabled(false);
    this->CounterSet_pushButton[index]->setEnabled(false);
    this->PwmSet_pushButton[index]->setEnabled(false);
    this->SwDec_pushButton[index]->setEnabled(false);
}

void TC_Form::mode_lock(int index, int mode)
{
    if ( 2 == mode )
    {
        mode = PWM_MODE;
    }
    this->TcMode_comboBox[index]->setEnabled(true);
    this->TiMode_comboBox[index]->setEnabled(false);
    this->ToMode_comboBox[index]->setEnabled(false);
    this->Retrigger_comboBox[index]->setEnabled(false);
    this->PresetValue_lineEdit[index]->setEnabled(false);
    this->PulseWidth_lineEdit[index]->setEnabled(false);
    this->PwmPeriod_lineEdit[index]->setEnabled(false);
    this->PwmDuty_lineEdit[index]->setEnabled(false);

    this->TimerSet_pushButton[index]->setEnabled(false);
    this->CounterSet_pushButton[index]->setEnabled(false);
    this->PwmSet_pushButton[index]->setEnabled(false);
    this->SwDec_pushButton[index]->setEnabled(false);

    switch (mode)
    {
    case TIMER_MODE:
    {
        this->TiMode_comboBox[index]->setEnabled(true);
        this->ToMode_comboBox[index]->setEnabled(true);
        this->Retrigger_comboBox[index]->setEnabled(true);
        this->PresetValue_lineEdit[index]->setEnabled(true);
        this->PulseWidth_lineEdit[index]->setEnabled(true);

        this->TimerSet_pushButton[index]->setEnabled(true);
        break;
    }
    case COUNTER_MODE:
    {
        this->TiMode_comboBox[index]->setEnabled(true);
        this->ToMode_comboBox[index]->setEnabled(true);
        this->Retrigger_comboBox[index]->setEnabled(true);
        this->PresetValue_lineEdit[index]->setEnabled(true);
        this->PulseWidth_lineEdit[index]->setEnabled(true);

        this->CounterSet_pushButton[index]->setEnabled(true);
        break;
    }
    case PWM_MODE:
    {
        this->TiMode_comboBox[index]->setEnabled(true);
        this->PwmPeriod_lineEdit[index]->setEnabled(true);
        this->PwmDuty_lineEdit[index]->setEnabled(true);

        this->PwmSet_pushButton[index]->setEnabled(true);
        break;
    }
    default:
        break;
    }
}



// ------------ slot ---------------
void TC_Form::on_PwmPeriod_0_lineEdit_textEdited(const QString &arg1)
{
    int index = 0;
    this->read_pwm_data(index);
}

void TC_Form::on_PwmDuty_0_lineEdit_textEdited(const QString &arg1)
{
    int index = 0;
    this->read_pwm_data(index);
}

void TC_Form::on_PwmPeriod_1_lineEdit_textEdited(const QString &arg1)
{
    int index = 1;
    this->read_pwm_data(index);
}

void TC_Form::on_PwmDuty_1_lineEdit_textEdited(const QString &arg1)
{
    int index = 1;
    this->read_pwm_data(index);
}

void TC_Form::on_CounterSet_0_pushButton_clicked()
{
    int index = 0;
    Counter_struct strCounter;

    strCounter.cont_single = this->Retrigger_comboBox[index]->currentIndex();
    strCounter.counter_const = this->PresetValue_lineEdit[index]->text().toInt();
    strCounter.Ti_Gate_MODE = this->TiMode_comboBox[index]->currentIndex();

    if ( 3 == this->ToMode_comboBox[index]->currentIndex() )
    {
        strCounter.Tout_mode = 4;
    }
    else
    {
        strCounter.Tout_mode = this->ToMode_comboBox[index]->currentIndex();
    }

    strCounter.Tout_width = this->PulseWidth_lineEdit[index]->text().toInt();

    Status = EX94421A_counter_set( CardID, index, &strCounter );
}

void TC_Form::on_CounterSet_1_pushButton_clicked()
{
    int index = 1;
    Counter_struct strCounter;

    strCounter.cont_single = this->Retrigger_comboBox[index]->currentIndex();
    strCounter.counter_const = this->PresetValue_lineEdit[index]->text().toInt();
    strCounter.Ti_Gate_MODE = this->TiMode_comboBox[index]->currentIndex();

    if ( 3 == this->ToMode_comboBox[index]->currentIndex() )
    {
        strCounter.Tout_mode = 4;
    }
    else
    {
        strCounter.Tout_mode = this->ToMode_comboBox[index]->currentIndex();
    }

    strCounter.Tout_width = this->PulseWidth_lineEdit[index]->text().toInt();

    Status = EX94421A_counter_set( CardID, index, &strCounter );
}

void TC_Form::on_PwmSet_0_pushButton_clicked()
{
    int index = 0;
    PWM_struct strPWM;

    strPWM.PWM_duty = this->PwmDuty_lineEdit[index]->text().toInt();
    strPWM.PWM_freq = this->PwmPeriod_lineEdit[index]->text().toInt();
    strPWM.Ti_Gate_MODE = this->TiMode_comboBox[index]->currentIndex();

    Status = EX94421A_PWM_set( CardID, index, &strPWM );
}

void TC_Form::on_PwmSet_1_pushButton_clicked()
{
    int index = 1;
    PWM_struct strPWM;

    strPWM.PWM_duty = this->PwmDuty_lineEdit[index]->text().toInt();
    strPWM.PWM_freq = this->PwmPeriod_lineEdit[index]->text().toInt();
    strPWM.Ti_Gate_MODE = this->TiMode_comboBox[index]->currentIndex();

    Status = EX94421A_PWM_set( CardID, index, &strPWM );
}

void TC_Form::on_TimerSet_0_pushButton_clicked()
{
    int index = 0;
    Timer_struct strTimer;
    strTimer.cont_single = this->Retrigger_comboBox[index]->currentIndex();
    strTimer.Ti_Gate_MODE = this->TiMode_comboBox[index]->currentIndex();
    strTimer.time_const = this->PresetValue_lineEdit[index]->text().toInt();

    if ( 3 == this->ToMode_comboBox[index]->currentIndex() )
    {
        strTimer.Tout_mode = 4;
    }
    else
    {
        strTimer.Tout_mode = this->ToMode_comboBox[index]->currentIndex();
    }

    strTimer.Tout_width = this->PulseWidth_lineEdit[index]->text().toInt();

    Status = EX94421A_timer_set( CardID, index, &strTimer );
}

void TC_Form::on_TimerSet_1_pushButton_clicked()
{
    int index = 1;
    Timer_struct strTimer;
    strTimer.cont_single = this->Retrigger_comboBox[index]->currentIndex();
    strTimer.Ti_Gate_MODE = this->TiMode_comboBox[index]->currentIndex();
    strTimer.time_const = this->PresetValue_lineEdit[index]->text().toInt();

    if ( 3 == this->ToMode_comboBox[index]->currentIndex() )
    {
        strTimer.Tout_mode = 4;
    }
    else
    {
        strTimer.Tout_mode = this->ToMode_comboBox[index]->currentIndex();
    }

    strTimer.Tout_width = this->PulseWidth_lineEdit[index]->text().toInt();

    Status = EX94421A_timer_set( CardID, index, &strTimer );
}

void TC_Form::on_SwDec_0_pushButton_clicked()
{
    Status = EX94421A_TC_set( CardID, 0, 1, 3 );
}

void TC_Form::on_SwDec_1_pushButton_clicked()
{
    Status = EX94421A_TC_set( CardID, 1, 1, 3 );
}

void TC_Form::on_TcControl_0_pushButton_toggled(bool checked)
{
    int index = 0;

    if ( true == checked )
    {
        this->TcControl_pushButton[index]->setText("Control Off");

        Status = EX94421A_TC_start( CardID, index );
        this->object_lock(index);

        if ( COUNTER_MODE == this->TcMode_comboBox[index]->currentIndex() )
        {
            this->SwDec_pushButton[index]->setEnabled(true);
        }
    }
    else
    {
        this->TcControl_pushButton[index]->setText("Control On");

        Status = EX94421A_TC_stop( CardID, index );
        this->mode_lock(index, this->TcMode_comboBox[index]->currentIndex());
    }
}

void TC_Form::on_TcControl_1_pushButton_toggled(bool checked)
{
    int index = 1;

    if ( true == checked )
    {
        this->TcControl_pushButton[index]->setText("Control Off");

        Status = EX94421A_TC_start( CardID, index );
        this->object_lock(index);

        if ( COUNTER_MODE == this->TcMode_comboBox[index]->currentIndex() )
        {
            this->SwDec_pushButton[index]->setEnabled(true);
        }
    }
    else
    {
        this->TcControl_pushButton[index]->setText("Control On");

        Status = EX94421A_TC_stop( CardID, index );
        this->mode_lock(index, this->TcMode_comboBox[index]->currentIndex());
    }

}

void TC_Form::on_TcMode_0_comboBox_currentIndexChanged(int index)
{
    int timer_ID = 0;
    this->mode_lock(timer_ID, index);
}

void TC_Form::on_TcMode_1_comboBox_currentIndexChanged(int index)
{
    int timer_ID = 1;
    this->mode_lock(timer_ID, index);
}

void TC_Form::on_TiGatePolarity_0_checkBox_clicked(bool checked)
{
    int index = 0;
    if ( true == checked )
    {
        Status = EX94421A_TC_input_polarity_set( CardID, index, 0, ACTIVE );
    }
    else
    {
        Status = EX94421A_TC_input_polarity_set( CardID, index, 0, INACTIVE );
    }
}

void TC_Form::on_TiGatePolarity_1_checkBox_clicked(bool checked)
{
    int index = 1;
    if ( true == checked )
    {
        Status = EX94421A_TC_input_polarity_set( CardID, index, 0, ACTIVE );
    }
    else
    {
        Status = EX94421A_TC_input_polarity_set( CardID, index, 0, INACTIVE );
    }
}

void TC_Form::on_TiInputPolarity_0_checkBox_clicked(bool checked)
{
    int index = 0;
    if ( true == checked )
    {
        Status = EX94421A_TC_input_polarity_set( CardID, index, 1, ACTIVE );
    }
    else
    {
        Status = EX94421A_TC_input_polarity_set( CardID, index, 1, INACTIVE );
    }
}

void TC_Form::on_TiInputPolarity_1_checkBox_clicked(bool checked)
{
    int index = 1;
    if ( true == checked )
    {
        Status = EX94421A_TC_input_polarity_set( CardID, index, 1, ACTIVE );
    }
    else
    {
        Status = EX94421A_TC_input_polarity_set( CardID, index, 1, INACTIVE );
    }
}

void TC_Form::on_ToPolarity_0_checkBox_clicked(bool checked)
{
    int index = 0;
    if ( true == checked )
    {
        Status = EX94421A_TC_output_polarity_set( CardID, index, ACTIVE );
    }
    else
    {
        Status = EX94421A_TC_output_polarity_set( CardID, index, INACTIVE );
    }
}

void TC_Form::on_ToPolarity_1_checkBox_clicked(bool checked)
{
    int index = 1;
    if ( true == checked )
    {
        Status = EX94421A_TC_output_polarity_set( CardID, index, ACTIVE );
    }
    else
    {
        Status = EX94421A_TC_output_polarity_set( CardID, index, INACTIVE );
    }
}
